/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.NinePatchBackgroundPainter;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.LibGuiCommon;
import dev.tr7zw.trender.gui.impl.client.style.GuiStyle;
import dev.tr7zw.trender.gui.impl.client.style.TextureConstants;
import dev.tr7zw.trender.gui.impl.client.style.WidgetTextures;
import dev.tr7zw.trender.gui.widget.WItemSlot;
import dev.tr7zw.trender.gui.widget.WWidget;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2960;

@FunctionalInterface
public interface BackgroundPainter {
    public static final BackgroundPainter VANILLA = BackgroundPainter.createStyleVariants("widget/panel_", p -> {});
    public static final BackgroundPainter SLOT = (context, left, top, panel) -> {
        if (!(panel instanceof WItemSlot)) {
            ScreenDrawing.drawBeveledPanel(context, left - 1, top - 1, panel.getWidth() + 2, panel.getHeight() + 2, -1207959552, 0x4C000000, -1191182337);
        } else {
            WItemSlot slot = (WItemSlot)panel;
            for (int x = 0; x < slot.getWidth() / 18; ++x) {
                for (int y = 0; y < slot.getHeight() / 18; ++y) {
                    int sy;
                    int sx;
                    int index = x + y * (slot.getWidth() / 18);
                    float px = 0.015625f;
                    if (slot.isBigSlot()) {
                        sx = x * 18 + left - 4;
                        sy = y * 18 + top - 4;
                        ScreenDrawing.texturedRect(context, sx, sy, 26, 26, WItemSlot.SLOT_TEXTURE, 18.0f * px, 0.0f, 44.0f * px, 26.0f * px, -1);
                        if (slot.getFocusedSlot() != index) continue;
                        ScreenDrawing.texturedRect(context, sx, sy, 26, 26, WItemSlot.SLOT_TEXTURE, 18.0f * px, 26.0f * px, 44.0f * px, 52.0f * px, -1);
                        continue;
                    }
                    sx = x * 18 + left;
                    sy = y * 18 + top;
                    ScreenDrawing.texturedRect(context, sx, sy, 18, 18, WItemSlot.SLOT_TEXTURE, 0.0f, 0.0f, 18.0f * px, 18.0f * px, -1);
                    if (slot.getFocusedSlot() != index) continue;
                    ScreenDrawing.texturedRect(context, sx, sy, 18, 18, WItemSlot.SLOT_TEXTURE, 0.0f, 26.0f * px, 18.0f * px, 44.0f * px, -1);
                }
            }
        }
    };

    public void paintBackground(RenderContext var1, int var2, int var3, WWidget var4);

    public static BackgroundPainter createColorful(int panelColor) {
        return (context, left, top, panel) -> ScreenDrawing.drawGuiPanel(context, left, top, panel.getWidth(), panel.getHeight(), panelColor);
    }

    public static BackgroundPainter createColorful(int panelColor, float contrast) {
        return (context, left, top, panel) -> {
            int shadowColor = ScreenDrawing.multiplyColor(panelColor, 1.0f - contrast);
            int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.0f + contrast);
            ScreenDrawing.drawGuiPanel(context, left, top, panel.getWidth(), panel.getHeight(), shadowColor, panelColor, hilightColor, -16777216);
        };
    }

    public static NinePatchBackgroundPainter createNinePatch(class_2960 texture) {
        return new NinePatchBackgroundPainter(texture);
    }

    public static BackgroundPainter createStyleVariants(String prefix, Consumer<BackgroundPainter> configurator) {
        EnumMap<GuiStyle, BackgroundPainter> styleMap = new EnumMap<GuiStyle, BackgroundPainter>(GuiStyle.class);
        for (GuiStyle style : GuiStyle.values()) {
            BackgroundPainter painter = BackgroundPainter.createGuiSprite(WidgetTextures.getId(prefix + style.getPrefix()));
            configurator.accept(painter);
            styleMap.put(style, painter);
        }
        return (context, left, top, panel) -> ((BackgroundPainter)styleMap.get((Object)LibGui.getGuiStyle())).paintBackground(context, left, top, panel);
    }

    public static BackgroundPainter createStyleVariantsNinePatch(String prefix, Consumer<NinePatchBackgroundPainter> configurator) {
        EnumMap<GuiStyle, NinePatchBackgroundPainter> styleMap = new EnumMap<GuiStyle, NinePatchBackgroundPainter>(GuiStyle.class);
        for (GuiStyle style : GuiStyle.values()) {
            NinePatchBackgroundPainter painter = BackgroundPainter.createNinePatch(LibGuiCommon.id(prefix + style.getPrefix() + ".png"));
            configurator.accept(painter);
            styleMap.put(style, painter);
        }
        return (context, left, top, panel) -> ((BackgroundPainter)styleMap.get((Object)LibGui.getGuiStyle())).paintBackground(context, left, top, panel);
    }

    public static BackgroundPainter createGuiSprite(class_2960 texture) {
        Objects.requireNonNull(texture, "Texture cannot be null");
        return (context, left, top, panel) -> {
            RenderSystem.enableBlend();
            TextureConstants.SpriteData data = TextureConstants.get(texture);
            context.blitSprite(texture, left, top, panel.getWidth(), panel.getHeight(), data.border(), data.border(), data.width(), data.height());
        };
    }
}

